/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brew_event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.brew_event.BrewEvent;
import net.satisfy.brewery.block.brew_event.BrewEvents;
import net.satisfy.brewery.block.brewingstation.BrewKettleBlock;
import net.satisfy.brewery.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.block.property.Liquid;
import net.satisfy.brewery.registry.BlockStateRegistry;
import org.jetbrains.annotations.Nullable;

public class BrewHelper {
    @Nullable
    public static BlockPos getBlock(Block block, Set<BlockPos> components, Level level) {
        for (BlockPos pos : components) {
            if (level.m_8055_(pos).m_60734_() != block) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public static BlockPos getBlock(Class<?> clazz, Set<BlockPos> components, Level level) {
        for (BlockPos pos : components) {
            if (!clazz.isInstance(level.m_8055_(pos).m_60734_())) continue;
            return pos;
        }
        return null;
    }

    public static List<ResourceLocation> possibleEvents(BrewstationBlockEntity entity) {
        ArrayList<ResourceLocation> possibleEvents = new ArrayList<ResourceLocation>();
        List<ResourceLocation> runningEvents = BrewEvents.toLocations(entity.getRunningEvents());
        for (ResourceLocation event : BrewEvents.BREW_EVENTS.keySet()) {
            boolean canAdd = true;
            if (runningEvents.contains(event)) {
                canAdd = false;
            } else {
                for (ResourceLocation runningEvent : runningEvents) {
                    if (!BrewHelper.conflictsWith(event, runningEvent)) continue;
                    canAdd = false;
                    break;
                }
            }
            if (!canAdd) continue;
            possibleEvents.add(event);
        }
        return possibleEvents;
    }

    private static boolean conflictsWith(ResourceLocation event1, ResourceLocation event2) {
        return event1.equals((Object)BrewEvents.WHISTLE_EVENT) && event2.equals((Object)BrewEvents.KETTLE_EVENT) || event1.equals((Object)BrewEvents.KETTLE_EVENT) && event2.equals((Object)BrewEvents.WHISTLE_EVENT);
    }

    public static BrewEvent getRdmEvent(BrewstationBlockEntity entity) {
        List<ResourceLocation> possibleEvents = BrewHelper.possibleEvents(entity);
        if (possibleEvents.isEmpty()) {
            return null;
        }
        ResourceLocation eventLocation = possibleEvents.get(Objects.requireNonNull(entity.m_58904_()).m_213780_().m_188503_(possibleEvents.size()));
        Supplier<BrewEvent> type = BrewEvents.byId(eventLocation);
        assert (type != null);
        BrewEvent event = type.get();
        event.setTimeForEvent(entity.m_58904_().m_213780_().m_216339_(160, 400));
        return event;
    }

    public static void finishEvents(BrewstationBlockEntity entity) {
        Set<BrewEvent> eventSet = entity.getRunningEvents();
        if (eventSet.isEmpty()) {
            return;
        }
        Iterator<BrewEvent> iterator = eventSet.iterator();
        while (iterator.hasNext()) {
            BrewEvent event = iterator.next();
            if (event == null) continue;
            BrewHelper.endEvent(entity, iterator, event);
        }
    }

    public static void checkRunningEvents(BrewstationBlockEntity entity) {
        Set<BrewEvent> eventSet = entity.getRunningEvents();
        if (eventSet.isEmpty()) {
            return;
        }
        Iterator<BrewEvent> iterator = eventSet.iterator();
        while (iterator.hasNext()) {
            BrewEvent event = iterator.next();
            if (event == null) continue;
            event.tick(entity);
            if (event.isFinish(entity.getComponents(), entity.m_58904_())) {
                BrewHelper.endEvent(entity, iterator, event);
                entity.growSolved();
                continue;
            }
            if (event.getTimeLeft() > 0) continue;
            BrewHelper.endEvent(entity, iterator, event);
        }
    }

    public static void endEvent(BrewstationBlockEntity entity, Iterator<BrewEvent> iterator, BrewEvent event) {
        Brewery.LOGGER.warn("ending event! " + BrewEvents.getId(event));
        if (event == null) {
            return;
        }
        event.finish(entity.getComponents(), entity.m_58904_());
        iterator.remove();
    }

    public static void saveAdditional(BrewstationBlockEntity entity, CompoundTag compoundTag) {
        Set<BrewEvent> events = entity.getRunningEvents();
        if (events.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (BrewEvent event : events) {
            CompoundTag tag = event.save(new CompoundTag());
            tag.m_128359_("id", Objects.requireNonNull(BrewEvents.getId(event)).toString());
            tag.m_128405_("timeLeft", event.getTimeLeft());
            list.add((Object)tag);
        }
        compoundTag.m_128365_("runningEvents", (Tag)list);
    }

    public static void load(BrewstationBlockEntity entity, CompoundTag compoundTag) {
        if (!compoundTag.m_128441_("runningEvents")) {
            return;
        }
        ListTag list = compoundTag.m_128437_("runningEvents", 10);
        for (Tag tag : list) {
            CompoundTag cTag;
            String id;
            ResourceLocation location;
            Supplier<BrewEvent> type;
            if (!(tag instanceof CompoundTag) || (type = BrewEvents.byId(location = ResourceLocation.m_135820_((String)(id = (cTag = (CompoundTag)tag).m_128461_("id"))))) == null) continue;
            BrewEvent event = type.get();
            event.load(compoundTag);
            event.setTimeForEvent(cTag.m_128451_("timeLeft"));
            entity.getRunningEvents().add(event);
        }
    }

    public static void resetWater(Set<BlockPos> components, Level level) {
        if (components == null || level == null) {
            return;
        }
        BlockPos basinPos = BrewHelper.getBlock(BrewKettleBlock.class, components, level);
        if (basinPos != null) {
            BlockState basinState = level.m_8055_(basinPos);
            Liquid liquid = (Liquid)((Object)basinState.m_61143_(BlockStateRegistry.LIQUID));
            if (liquid.equals((Object)Liquid.FILLED)) {
                return;
            }
            level.m_46597_(basinPos, (BlockState)basinState.m_61124_(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.FILLED)));
        }
    }
}

